/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.item;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.entity.ChainKnotEntity;
import com.github.legoatoom.connectiblechains.entity.Chainable;
import com.github.legoatoom.connectiblechains.tag.ModTagRegistry;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1804;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class ChainItemCallbacks {
    public static class_1269 chainUseEvent(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (player == null || player.method_5715()) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        class_2338 blockPos = hitResult.method_17777();
        class_2680 blockState = world.method_8320(blockPos);
        if (blockState.method_26164(ModTagRegistry.CHAIN_CONNECTIBLE)) {
            if (!class_1804.method_61166((class_1937)world, (class_2338)blockPos, entity -> entity.method_60952() == player).isEmpty()) {
                return class_1269.field_5811;
            }
            if (stack.method_31573(ModTagRegistry.CATENARY_ITEMS)) {
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    ChainKnotEntity knot = ChainKnotEntity.getOrCreate((class_1937)serverWorld, blockPos, stack.method_7909());
                    return knot.method_5688(player, hand);
                }
                return class_1269.field_5812;
            }
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                return ChainItemCallbacks.attachHeldChainsToBlock(player, serverWorld, blockPos);
            }
            if (!ChainItemCallbacks.collectChainablesAround(world, blockPos, entity -> entity.getChainData((class_1297)player) != null).isEmpty()) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public static class_1269 attachHeldChainsToBlock(class_1657 player, class_3218 world, class_2338 pos) {
        List<Chainable> list = ChainItemCallbacks.collectChainablesAround((class_1937)world, pos, entity -> entity.getChainData((class_1297)player) != null);
        ChainKnotEntity chainKnotEntity = null;
        for (Chainable chainable : list) {
            if (chainKnotEntity == null) {
                chainKnotEntity = ChainKnotEntity.getOrCreate((class_1937)world, pos, chainable.getSourceItem());
                chainKnotEntity.onPlace();
            }
            if (!chainable.canAttachTo((class_1297)chainKnotEntity)) continue;
            Chainable.ChainData chainData = chainable.getChainData((class_1297)player);
            assert (chainData != null);
            chainable.attachChain(new Chainable.ChainData((class_1297)chainKnotEntity, chainData.sourceItem), (class_1297)player, true);
        }
        if (!list.isEmpty()) {
            world.method_43276((class_6880)class_5712.field_28172, pos, class_5712.class_7397.method_43285((class_1297)player));
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static List<Chainable> collectChainablesAround(class_1937 world, class_2338 pos, Predicate<Chainable> predicate) {
        double distance = ConnectibleChains.runtimeConfig.getMaxChainRange();
        class_238 box = new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_1014(distance);
        return world.method_8390(class_1297.class, box, entity -> {
            Chainable chainable;
            return entity instanceof Chainable && predicate.test(chainable = (Chainable)entity);
        }).stream().map(Chainable.class::cast).toList();
    }

    @Environment(value=EnvType.CLIENT)
    public static void infoToolTip(class_1799 itemStack, class_1792.class_9635 ignoredTooltipContext, class_1836 ignoredTooltipType, List<class_2561> texts) {
        if (ConnectibleChains.runtimeConfig.doShowToolTip() && itemStack.method_31573(ModTagRegistry.CATENARY_ITEMS)) {
            if (class_437.method_25442()) {
                texts.add(1, (class_2561)class_2561.method_43471((String)"message.connectiblechains.connectible_chain_detailed").method_27692(class_124.field_1075));
            } else {
                texts.add(1, (class_2561)class_2561.method_43471((String)"message.connectiblechains.connectible_chain").method_27692(class_124.field_1054));
            }
        }
    }
}

